/*
 * Decompiled with CFR 0.152.
 */
package ags.communication;

import ags.communication.DataUtil;
import ags.communication.GenericHost;
import ags.controller.Configurable;
import ags.controller.FileType;
import ags.controller.Launcher;
import ags.disk.Disk33;
import ags.disk.Drive;
import ags.game.Game;
import ags.game.GameBase;
import ags.game.GameUtil;
import ags.game.Part;
import ags.script.Engine;
import ags.script.Target;
import ags.script.Variable;
import gnu.io.CommPort;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TransferHost
extends GenericHost {
    @Configurable(category=Configurable.CATEGORY.RUNTIME, isRequired=true)
    @FileType(value="txt")
    public static String INIT_FILE = "ags/resources/init.txt";
    @Configurable(category=Configurable.CATEGORY.RUNTIME, isRequired=true)
    public static String GAMES_DIR = "games";
    @Configurable(category=Configurable.CATEGORY.ADVANCED, isRequired=false)
    public static int MAX_CHUNK_SIZE = 4096;
    @Configurable(category=Configurable.CATEGORY.ADVANCED, isRequired=false)
    public static int MAX_ERRORS_ALLOWED = 10;
    @Configurable(category=Configurable.CATEGORY.ADVANCED, isRequired=false)
    public static int MAX_ACK_BURST = 16;
    public static final int BASIC_RUN = 54630;
    public static final int BASIC_PTR_START = 103;
    public static final int BASIC_PTR_LOMEM = 105;
    public static final int BASIC_PTR_HIMEM = 115;
    public static final int BASIC_PTR_END = 175;
    public static final String DRIVER_ACK = "hi";
    @Configurable(category=Configurable.CATEGORY.ADVANCED, isRequired=true)
    public static int NUM_ACK_RETRIES = 5;
    @Configurable(category=Configurable.CATEGORY.ADVANCED, isRequired=true)
    @FileType(value="o,asm,obj")
    public static String DECOMPRESSOR_ROUTINE = "ags/asm/deflate.o";
    boolean decompressorLoaded = false;

    public TransferHost() {
    }

    public TransferHost(CommPort port) {
        super(port);
    }

    public void init() throws IOException {
        Thread.currentThread().setName("Initalizing Serial Driver");
        System.out.println("Executing init script.");
        Engine.start(INIT_FILE);
        try {
            this.expect(DRIVER_ACK, 2000, false);
        }
        catch (IOException e) {
            Thread.currentThread().setName("Error during startup");
            System.out.println("Didn't get an immediate response from the driver, trying a few acknowledge tests.");
            try {
                this.testDriver();
                Thread.currentThread().setName("Recovered from startup error");
            }
            catch (IOException ex) {
                System.out.println("ALERT: Didn't detect the apple driver is running.  Ensure it is started (will retry in 20 seconds)");
                System.out.println("For example, try pressing ctrl-reset on the apple and typing CALL 2049");
            }
        }
    }

    public int sendRawData(byte[] fileData, int addressStart, int dataStart, int length) throws IOException, IOException {
        int offset = dataStart;
        int end = dataStart + length;
        int chunkSize = MAX_CHUNK_SIZE;
        int totalErrors = 0;
        int errors = 0;
        this.testDriver();
        while (offset < end && errors < MAX_ERRORS_ALLOWED) {
            Launcher.checkRuntimeStatus();
            int size = Math.min(chunkSize, end - offset);
            this.write("A");
            this.writeOutput(DataUtil.getWord(offset + addressStart));
            this.write("B");
            int useSize = 0xFF00 & size + 255 | 0xFF & size;
            this.writeOutput(DataUtil.getWord(useSize));
            this.write("C");
            this.writeOutput(fileData, offset, size);
            try {
                byte[] checksum = TransferHost.computeChecksum(fileData, offset, size);
                this.readBytes();
                this.write("D");
                this.expectBytes(checksum, 500);
                offset += chunkSize;
                errors = 0;
                chunkSize = MAX_CHUNK_SIZE;
            }
            catch (IOException e) {
                System.out.println("Checksum failed: " + e.getMessage());
                ++errors;
                ++totalErrors;
                if ((chunkSize /= 2) < 2) {
                    chunkSize = 2;
                }
                this.tryToFixDriver();
            }
        }
        if (errors >= MAX_ERRORS_ALLOWED) {
            throw new IOException("TOO MANY CHECKSUM ERRORS!  ABORTING TRANSFER!");
        }
        return totalErrors;
    }

    public void storeMemory(int address, byte ... b) throws IOException {
        System.out.println("Storing " + b.length + " bytes at " + Integer.toHexString(address));
        this.sendRawData(b, address, 0, b.length);
    }

    public void storeMemory(int address, int ... i) throws IOException {
        byte[] b = new byte[i.length];
        for (int x = 0; x < i.length; ++x) {
            b[x] = (byte)(i[x] & 0xFF);
        }
        this.storeMemory(address, b);
    }

    public void jmp(int address, boolean sub) throws IOException {
        this.testDriver();
        this.write("A");
        this.writeOutput(DataUtil.getWord(address));
        if (sub) {
            this.write("F");
        } else {
            this.write("E");
        }
    }

    public boolean startGame(GameBase game) throws IOException {
        Launcher.checkRuntimeStatus();
        Game g = null;
        Part p = null;
        if (game instanceof Game) {
            g = (Game)game;
            Thread.currentThread().setName("Executing game " + g.getName());
            if (g.getPart() != null && g.getPart().size() > 0) {
                for (Part gg : g.getPart()) {
                    System.out.println("Loading game part: " + gg.getName());
                    if (this.startGame(gg)) continue;
                    System.out.println("Load process terminated at part " + gg.getName());
                    return false;
                }
            }
            if (g.getType().equalsIgnoreCase("disk")) {
                this.bootDiskGame(g);
                return false;
            }
        } else {
            p = (Part)game;
        }
        if (game.getFile() != null && !"".equals(game.getFile())) {
            boolean isSubroutine;
            if (game.getType().equalsIgnoreCase("fc")) {
                int length = this.loadGame(game);
                this.storeMemory(216, 0);
                this.storeMemory(GameUtil.toInt(game.getStart()) - 1, 0);
                this.storeMemory(103, DataUtil.getWord(GameUtil.toInt(game.getStart())));
                this.storeMemory(175, DataUtil.getWord(GameUtil.toInt(game.getStart() + length)));
                this.storeMemory(105, DataUtil.getWord(GameUtil.toInt(game.getStart() + length)));
                this.storeMemory(115, DataUtil.getWord(48895));
                this.jmp(54630, false);
                return false;
            }
            if (!game.getType().equalsIgnoreCase("06")) {
                this.loadGame(game);
                return true;
            }
            this.loadGame(game);
            if (p != null && p.getAction().equals("load")) {
                return true;
            }
            boolean bl = isSubroutine = p != null && p.getAction().equalsIgnoreCase("subroutine");
            if (p == null || isSubroutine || p.getAction().equalsIgnoreCase("run")) {
                this.jmp(GameUtil.toInt(game.getStart()), isSubroutine);
            }
            if (isSubroutine) {
                for (int i = 0; i < 10000; i += 100) {
                    try {
                        this.testDriver();
                    }
                    catch (IOException e) {
                        DataUtil.wait(100);
                        continue;
                    }
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public int loadGame(GameBase g) throws IOException {
        if (g.getName() != null) {
            Thread.currentThread().setName("Launching " + g.getName());
            System.out.println("Sending: " + g.getName());
        } else {
            System.out.println("Sending game part (no name)");
        }
        String fileName = GAMES_DIR + "/" + g.getFile();
        byte[] fileData = DataUtil.getFileAsBytes(fileName);
        int address = GameUtil.toInt(g.getStart());
        int length = fileData.length;
        int offset = 0;
        if (g instanceof Part) {
            Part p = (Part)g;
            if (p.getOffset() != null) {
                offset = Math.min(length - 1, GameUtil.toInt(p.getOffset()));
            }
            if (p.getLength() != null) {
                length = Math.min(length - offset, GameUtil.toInt(p.getLength()));
            }
        }
        System.out.println("Starting address: " + g.getStart());
        System.out.println("Length: " + length);
        int totalErrors = this.sendRawData(fileData, address - offset, offset, length);
        System.out.println("Finished transfering game with " + totalErrors + " errors");
        return length;
    }

    public void testDriver() throws IOException {
        for (int numRetries = NUM_ACK_RETRIES; numRetries > 0; --numRetries) {
            Launcher.checkRuntimeStatus();
            try {
                this.write("@");
                this.expect(DRIVER_ACK, 1000, false);
                return;
            }
            catch (IOException iOException) {
                continue;
            }
        }
        throw new IOException("Failed to get response from driver after " + NUM_ACK_RETRIES + " retries");
    }

    public void tryToFixDriver() throws IOException {
        for (int i = 0; i < MAX_ACK_BURST; ++i) {
            this.write("@");
        }
        this.expect(DRIVER_ACK, 5000, false);
        DataUtil.wait(10);
        this.readBytes();
    }

    public byte getKey() throws IOException {
        Launcher.checkRuntimeStatus();
        this.write("G");
        for (int i = 0; i < 500 && this.inputAvailable() == 0; ++i) {
            DataUtil.wait(1);
        }
        if (this.inputAvailable() > 0) {
            byte[] b = new byte[1];
            this.readInput(b);
            byte bb = b[0];
            if (bb >= 0) {
                return 0;
            }
            return (byte)(bb & 0x7F);
        }
        System.out.println("Not getting a response from the apple, testing connection");
        this.testDriver();
        System.out.println("Connection working, how odd.  Going on...");
        return 0;
    }

    protected static byte[] computeChecksum(byte[] data, int start, int size) {
        byte checksum = 0;
        for (int i = start; i < start + size; ++i) {
            checksum = (byte)(0xFF & checksum ^ 0xFF & data[i]);
        }
        return new byte[]{checksum};
    }

    private void bootDiskGame(Game g) throws IOException {
        Thread.currentThread().setName("Running in disk mode for game " + g.getName());
        System.out.println("Booting disk-based game: " + g.getName());
        ClassLoader c = TransferHost.class.getClassLoader();
        Drive d = new Drive(this);
        if (g.getFile() != null) {
            try {
                String filename = GAMES_DIR + "/" + g.getFile();
                System.out.println("Attempting to load disk image " + filename);
                Disk33 boot = new Disk33(filename);
                d.insertDisk(5, 0, boot);
            }
            catch (IOException ex) {
                Logger.getLogger(TransferHost.class.getName()).log(Level.SEVERE, "Error inserting disk " + g.getName(), ex);
            }
        }
        if (g.getDisk() != null) {
            for (Game.Disk diskData : g.getDisk()) {
                try {
                    Disk33 otherDisk = new Disk33(c.getResourceAsStream(GAMES_DIR + "/" + diskData.getFile()));
                    d.insertDisk(diskData.getSlot() - 1, diskData.getDrive() - 1, otherDisk);
                }
                catch (IOException ex) {
                    Logger.getLogger(TransferHost.class.getName()).log(Level.SEVERE, "Error inserting disk " + diskData.getName(), ex);
                }
            }
        }
        d.boot();
    }

    public void loadDriver(String driverName, int address) {
        try {
            String filename = "";
            Target gs = Target.getTarget("apple2gs_setup");
            String slot = Variable.getVariable("slot").getValue();
            filename = gs != null && gs.isRunAlready() ? "ags/asm/" + driverName + "_gs_port" + slot + ".o" : "ags/asm/" + driverName + "_ssc_slot" + slot + ".o";
            InputStream data = ClassLoader.getSystemResourceAsStream(filename);
            byte[] driverData = new byte[data.available()];
            data.read(driverData);
            data.close();
            this.sendRawData(driverData, address, 0, driverData.length);
        }
        catch (IOException ex) {
            Logger.getLogger(TransferHost.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void loadDecompressor() throws IOException {
        if (!this.decompressorLoaded) {
            byte[] decompressor = DataUtil.getFileAsBytes(DECOMPRESSOR_ROUTINE);
            this.sendRawData(decompressor, 48384, 0, decompressor.length);
            this.jmp(48384, true);
            this.testDriver();
        }
        this.decompressorLoaded = true;
    }

    public void sendCompressedData(byte[] compressedData) throws IOException {
        Launcher.checkRuntimeStatus();
        this.loadDecompressor();
        this.write("H");
        int next = 2;
        long wait = 0L;
        for (int i = 0; i < compressedData.length; ++i) {
            if (next == i) {
                this.out.flush();
                DataUtil.nanosleep(wait);
                if ((compressedData[i] & 0x80) == 0) {
                    next = i + compressedData[i] + 1;
                    wait = 73L - DataUtil.NANOS_PER_CHAR;
                } else {
                    next = i + 3;
                    if (compressedData[i + 1] != 0 || compressedData[i + 2] != 0) {
                        int reps = Math.abs((compressedData[i] & 0x7F) + 2);
                        wait = DataUtil.cyclesToNanos(reps * 101) + DataUtil.NANOS_PER_CHAR;
                    } else {
                        wait = DataUtil.cyclesToNanos(50L);
                    }
                }
            }
            this.writeOutput(compressedData, i, 1);
        }
        this.out.flush();
        DataUtil.nanosleep(wait);
    }

    public void toggleSwitch(int address) throws IOException {
        this.loadDecompressor();
        this.write("I");
        this.writeOutput(DataUtil.getWord(address));
    }
}

